/* Contain the entire script within a function because REPORTER onrefCHEST_BELT_LOADly has a single JavaScript realm
 * for the entire session. */

// In reporter, make sure to have this JS defined before all other scoring JS so that getModifierValue is defined

head_and_neck_score();

/**
 * Performs the head and neck score calculation for the specified models
 */
function getModifierValue(status, key) {
    const value = get_variable_value(status, key, "string");

    if (value == "Yes") {
        if (key.includes("CHEST_BELT_LOAD")) {
            return -40;
        }
        return -20;
    }

    if (value == "No") return 0;
    return parseFloat(value); // fallback if it's actually a number in string form
}
function head_and_neck_score() {
    let templ = Template.GetCurrent();
    // let models = get_model_list();
    let models = ["M1", "T1"];
    let body_region_label = `head and neck`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head score and modifiers */

            /* Shared */

            let head_hic_score = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_HIC_SCORE`,
                "float",
                templ
            );
            let head_hic_score_banded = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE_ENCAP_BANDED`, "float");
            let head_peack_acc_score = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_PEAK_ACCELERATION_SCORE`,
                "float",
                templ
            );
            let head_three_ms_exc_score = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                "float",
                templ
            );
            let head_three_ms_exc_score_banded = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE_ENCAP_BANDED`,
                "float"
            );

            let head_hic_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_HIC_CAPPING_LIMIT`);
            let head_tms_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_CAPPING_LIMIT`
            );

            // let hb_mod = getModifierValue(status, `${m}_${occ}_HEAD_BOTTOMING_OUT_MODIFIER`);

            // let haz_ab_mod = getModifierValue(status, `${m}_${occ}_HEAD_HAZARDOUS_AIRBAG_DEPLOYMENT_MODIFIER`);
            // let inc_ab_mod = getModifierValue(status, `${m}_${occ}_HEAD_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`);
            // let ab_con_mod = getModifierValue(status, `${m}_${occ}_HEAD_AIRBAG_CONTACT_MODIFIER`);

            let hb_mod = getModifierValue(status, `${"M1"}_${occ}_HEAD_BOTTOMING_OUT_MODIFIER`);

            let haz_ab_mod = getModifierValue(status, `${"M1"}_${occ}_HEAD_HAZARDOUS_AIRBAG_DEPLOYMENT_MODIFIER`);
            let inc_ab_mod = getModifierValue(status, `${"M1"}_${occ}_HEAD_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`);
            let ab_con_mod = getModifierValue(status, `${"M1"}_${occ}_HEAD_AIRBAG_CONTACT_MODIFIER`);

            /* If the head peak acceleration is less than 80g and score is 4 other scores hic and 3 ms exc should be zero */

            /* if (head_peack_acc_score == 4) {
           /*     head_hic_score = 0;
           /*     head_three_ms_exc_score = 0;
           /* }
            /*    /*Driver */
            /*    let steering_wheel_airbag_present;
        /*    let steering_column_intrusion_x_score;
        /*    let steering_column_intrusion_y_score;
        /*    let steering_column_intrusion_z_score;
        /*    let damage_score;
        /*    if (occ == "DRIVER") {
        /*        steering_wheel_airbag_present = get_variable_value(
        /*            status,
        /*            `${m}_${occ}_STEERING_WHEEL_AIRBAG_MODIFIER`
        /*        );
        /*        steering_column_intrusion_x_score = get_variable_value(
        /*            status,
        /*            `${m}_STRUCTURE_STEERING_COLUMN_FORE_AFT_INTRUSION_SCORE`,
        /*            "float"
        /*        );
        /*        steering_column_intrusion_y_score = get_variable_value(
        /*            status,
        /*            `${m}_STRUCTURE_STEERING_COLUMN_LATERAL_INTRUSION_SCORE`,
        /*            "float"
        /*        );
        /*        steering_column_intrusion_z_score = get_variable_value(
        /*            status,
        /*            `${m}_STRUCTURE_STEERING_COLUMN_VERTICAL_INTRUSION_SCORE`,
        /*            "float"
        /*        );
                /* DAMAGE is a 2024 addition, we don't want a fail in the 2020 template */
            /*        let year;
        /*        year = get_variable_value(status, `YEAR`, "int");
        /*        if (year != "2020") {
        /*            damage_score = get_variable_value(status, `${m}_${occ}_HEAD_DAMAGE_SCORE`, "float");
        /*        } else {
        /*            damage_score = 0;
        /*        }
        /*    }

            /* Neck score */
            let neck_axial_tension_score;
            let neck_shear_score;
            let neck_extension_score;
            let neck_axial_tension_score_banded;
            let neck_shear_score_banded;
            let neck_extension_score_banded;
            let neck_axial_capping_limit;
            let neck_shear_capping_limit;
            let neck_shear_exceedence_capping_limit;
            let neck_tension_exceedence_capping_limit;
            let neck_extension_capping_limit;
            let neck_axial_tension_passenger_score;
            let neck_shear_passenger_score;
            let neck_extension_passenger_score;
            let neck_axial_tension_passenger_score_banded;
            let neck_shear_passenger_score_banded;
            let neck_extension_passenger_score_banded;

            switch (occ) {
                case "DRIVER":
                    neck_axial_tension_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_AXIAL_SCORE`,
                        "float",
                        templ
                    );
                    neck_shear_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_SHEAR_SCORE`,
                        "float",
                        templ
                    );
                    neck_extension_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_SCORE`,
                        "float",
                        templ
                    );
                    neck_axial_tension_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_shear_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_extension_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_SCORE_ENCAP_BANDED`,
                        "float"
                    );

                    neck_axial_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_AXIAL_CAPPING_LIMIT`);
                    neck_shear_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_SHEAR_CAPPING_LIMIT`);
                    neck_extension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_CAPPING_LIMIT`
                    );
                    break;
                case "FRONT_PASSENGER":
                    neck_axial_tension_passenger_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_AXIAL_PASSENGER_SCORE`,
                        "float",
                        templ
                    );
                    neck_shear_passenger_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_SHEAR_PASSENGER_SCORE`,
                        "float",
                        templ
                    );
                    neck_extension_passenger_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_PASSENGER_SCORE`,
                        "float",
                        templ
                    );
                    neck_axial_tension_passenger_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_PASSENGER_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_shear_passenger_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_PASSENGER_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_extension_passenger_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_PASSENGER_SCORE_ENCAP_BANDED`,
                        "float"
                    );

                    neck_axial_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_AXIAL_CAPPING_LIMIT`);
                    neck_shear_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_SHEAR_CAPPING_LIMIT`);
                    neck_extension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_CAPPING_LIMIT`
                    );
                    neck_shear_exceedence_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_EXCEEDENCE_CAPPING_LIMIT`
                    );
                    neck_extension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_CAPPING_LIMIT`
                    );
                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let head_score = 0;
            let neck_score = 0;
            let neck_score_passenger = 0;
            let modifier_total = 0;
            let head_and_neck_score = 0;
            let head_and_neck_score_nomod = 0;
            let head_and_neck_score_passenger = 0;
            let head_and_neck_score_passenger_nomod = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let head_capping_limit = "";
            let neck_capping_limit = "";
            let head_neck_capping_limit = "";

            /* If we have all the required variables, calculate the final scores */
            if (true) {
                /* Head score is sum of score with modifiers.
                 * For the driver, steering wheel airbag must be present or score remains zero. */

                head_score = Math.max(
                    head_peack_acc_score,
                    Math.min(head_hic_score_banded, head_three_ms_exc_score_banded)
                );

                /* Neck score is minimum of axial, shear, and bending components */

                neck_score = Math.min(
                    neck_axial_tension_score_banded,
                    neck_shear_score_banded,
                    neck_extension_score_banded
                );
                neck_score_passenger = Math.min(
                    neck_axial_tension_passenger_score_banded,
                    neck_shear_passenger_score_banded,
                    neck_extension_passenger_score_banded
                );

                modifier_total = hb_mod + haz_ab_mod + inc_ab_mod + ab_con_mod;

                /* Bound the score between upper and lower limits */

                head_score = Math.max(Math.min(head_score, 100.0), 0.0);
                neck_score = Math.max(Math.min(neck_score, 100.0), 0.0);
                neck_score_passenger = Math.max(Math.min(neck_score_passenger, 100.0), 0.0);

                LogPrint(`${m} ${occ} head score = ${head_score}`);
                LogPrint(`${m} ${occ} neck score = ${neck_score}`);
                LogPrint(`${m} ${occ} neck score = ${neck_score_passenger}`);

                /* Overall score is minimum of head and neck scores */

                const h = head_score;
                const n = neck_score;
                const np = neck_score_passenger;
                const mod = modifier_total;

                head_and_neck_score = Math.min(h, n) + mod;
                head_and_neck_score_nomod = Math.min(h, n);
                head_and_neck_score_passenger = Math.min(h, np) + mod;
                head_and_neck_score_passenger_nomod = Math.min(h, np);

                head_and_neck_score = Math.max(Math.min(head_and_neck_score, 100.0), 0.0);
                head_and_neck_score_passenger = Math.max(Math.min(head_and_neck_score_passenger, 100.0), 0.0);

                head_and_neck_score = replaceNaNWithMissing(head_and_neck_score);
                head_and_neck_score_nomod = replaceNaNWithMissing(head_and_neck_score_nomod);
                head_and_neck_score_passenger = replaceNaNWithMissing(head_and_neck_score_passenger);
                head_and_neck_score_passenger_nomod = replaceNaNWithMissing(head_and_neck_score_passenger_nomod);

                // head_and_neck_score = Math.min(head_score, neck_score) + modifier_total;
                // head_and_neck_score_nomod = Math.min(head_score, neck_score);
                // head_and_neck_score_passenger = Math.min(head_score, neck_score_passenger) + modifier_total;
                // head_and_neck_score_passenger_nomod = Math.min(head_score, neck_score_passenger);
                // head_and_neck_score = Math.max(Math.min(head_and_neck_score, 100.0), 0.0);
                // head_and_neck_score_passenger = Math.max(Math.min(head_and_neck_score_passenger, 100.0), 0.0);

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */

                if (head_hic_capping_limit == "" && head_tms_capping_limit == "") {
                    head_capping_limit = "";
                }
                if (
                    (occ == "DRIVER" &&
                        neck_axial_capping_limit == "" &&
                        neck_shear_capping_limit == "" &&
                        neck_extension_capping_limit == "") ||
                    occ == "FRONT_PASSENGER"
                ) {
                    neck_capping_limit = "";
                }
                if (head_capping_limit == "" && neck_capping_limit == "") {
                    head_neck_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Overall scores */
            let head_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_FINAL_SCORE`,
                "Final head score",
                head_score.toString(),
                "String",
                false,
                true
            );
            let head_hic_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_HIC_SCORE`,
                " head HIC score",
                head_hic_score.toString(),
                "String",
                false,
                true
            );
            let head_three_ms_exc_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                " head three ms exe score",
                head_three_ms_exc_score.toString(),
                "String",
                false,
                true
            );
            let neck_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_NECK_FINAL_SCORE`,
                "Final neck score",
                neck_score.toString(),
                "String",
                false,
                true
            );
            let neck_score_passenger_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_NECK_FINAL_PASSENGER_SCORE`,
                "Final neck score",
                neck_score_passenger.toString(),
                "String",
                false,
                true
            );
            let head_neck_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                head_and_neck_score.toString(),
                "String",
                false,
                true
            );
            let head_neck_score_passenger_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_FINAL_PASSENGER_SCORE`,
                `Final ${body_region_label} score`,
                head_and_neck_score_passenger.toString(),
                "String",
                false,
                true
            );
            let modifier_total_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_MODIFIER_TOTAL`,
                `Final ${body_region_label} modifier`,
                modifier_total.toString(),
                "String",
                false,
                true
            );
            let head_and_neck_score_nomod_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_NOMOD_SCORE`,
                `Final ${body_region_label} Score no mod`,
                head_and_neck_score_nomod.toString(),
                "String",
                false,
                true
            );
            let head_and_neck_score_nomod_pass_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_PASS_NOMOD_SCORE`,
                `Final ${body_region_label} Pass Score no mod`,
                head_and_neck_score_passenger_nomod.toString(),
                "String",
                false,
                true
            );

            /* Capping limits */
            let head_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_CAPPING_LIMIT`,
                "Head capping limit (*asterisk if limit exceeded; empty string otherwise)",
                head_capping_limit,
                "String",
                false,
                true
            );
            let neck_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_NECK_CAPPING_LIMIT`,
                "Neck capping limit (*asterisk if limit exceeded; empty string otherwise)",
                neck_capping_limit,
                "String",
                false,
                true
            );
            let head_neck_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_NECK_CAPPING_LIMIT`,
                "Head and neck capping limit (*asterisk if limit exceeded; empty string otherwise)",
                head_neck_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_HEAD_NECK_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
